//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TGLForm(Owner),
        Phi(0.0f), Theta(0.0f),
        PozycjaX(0.0f), PozycjaY(0.0f), PozycjaZ(0.0f)
{
   KolorTla=clBlack;
   debug_mode=false;
   NatezenieSwiatlaOtoczenia=0.5f;
   Swiatlo1();
   Obracaj(10.0f,1.0f,0.0f);
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujScene()
{
   //obroty kontrolowane klawiszami
   glRotatef(Phi, 0.0, 1.0, 0.0); //wokol OY
   glRotatef(Theta, 1.0, 0.0, 0.0); //wokol OX

   //przesuniecia kontrolowane klawiszami
   glTranslatef(PozycjaX,PozycjaY,PozycjaZ);

   glPushMatrix();

   const float x0=1.0;
   const float y0=1.0;
   const float z0=1.0;

   /*
   //rysowanie ostroslupa
   RysujOstroslup(x0,y0,z0);

   //kolejne ostroslupy
   for (int i=0;i<3;i++)
   {
      glRotatef(90.0, 0.0, 1.0, 0.0);
      RysujOstroslup(x0,y0,z0);
   }
   glRotatef(90.0, 0.0, 1.0, 0.0); //dopelnienie pelnego obrotu
   */

   //rysowanie szescianu
   //glColor3ub(0,0,150);
   RysujSzescian(x0);

   glPopMatrix();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::RysujOstroslup(float x0,float y0,float z0) const
{
   //Rysowanie trojkata
   glBegin(GL_TRIANGLES);
   //ustalanie trzech wierzcholkow trojkata (werteksow (x,y,z))
   //(0,0,z) jest mniej wiecej w srodku ekranu

   //tylna
   glColor3ub(255,255,0); //zolty
   glNormal3f(0,0,-1.0); //w glab
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, y0, z0); //gorny

   //podstawa
   glColor3ub(0,255,0); //zielony
   glNormal3f(0,-1.0,0); //do dolu
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, -y0, 2*z0); //dolny przedni

   //lewa
   glColor3ub(255,0,0); //czerwony
   glVertex3f(-x0, -y0, z0); //dolny lewy
   glVertex3f(0, -y0, 2*z0); //dolny przedni
   glVertex3f(0, y0, z0); //gorny

   //prawa
   glColor3ub(0,0,255); //niebieski
   glVertex3f(x0, -y0, z0); //dolny prawy
   glVertex3f(0, -y0, 2*z0); //dolny przedni
   glVertex3f(0, y0, z0); //gorny

   //koniec rysowania figury
   glEnd();
}

void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
   //obroty
   if (Shift.Empty())
   {
      switch (Key)
      {
         case VK_LEFT:   Phi-=3; break;
         case VK_RIGHT:  Phi+=3; break;
         case VK_UP :    Theta-=3; break;
         case VK_DOWN:   Theta+=3; break;

         case 'q':
         case 'Q':
            Timer1->Enabled=!Timer1->Enabled;
            break;

         case VK_OEM_MINUS:
            NatezenieSwiatlaOtoczenia-=0.01;
            break;
         case VK_OEM_PLUS:
         case '=':
            NatezenieSwiatlaOtoczenia+=0.01;
            break;
      }
   }

   //przesuniecia w pionie i poziomie
   if (Shift.Contains(ssCtrl))
   {
      switch (Key)
      {
            case VK_LEFT:  PozycjaX-=0.1; break;
            case VK_RIGHT: PozycjaX+=0.1; break;
            case VK_UP:    PozycjaY+=0.1; break;
            case VK_DOWN:  PozycjaY-=0.1; break;
      }
   }

   //przesuniecia w poziomie i przod-tyl
   if (Shift.Contains(ssShift))
   {
      switch (Key)
      {
         case VK_LEFT:  PozycjaX-=0.1; break;
         case VK_RIGHT: PozycjaX+=0.1; break;
         case VK_UP:    PozycjaZ-=0.1; break;
         case VK_DOWN:  PozycjaZ+=0.1; break;
      }
   }

   GL_RysujScene();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
   Phi+=1;
   Theta+=0.1;
   GL_RysujScene();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RysujSzescian(float krawedz) const
{
	const float a=krawedz;

	glBegin(GL_QUADS);
	//tylnia
   glNormal3f(0,0,-1); //wektory normalne skierowane na zewnatrz
	glVertex3f(-a,-a,-a);
	glVertex3f(-a,a,-a);
	glVertex3f(a,a,-a);
	glVertex3f(a,-a,-a);
	//przednia
   glNormal3f(0,0,1);
	glVertex3f(-a,-a,a);
	glVertex3f(a,-a,a);
	glVertex3f(a,a,a);
	glVertex3f(-a,a,a);

	//prawa
   glNormal3f(1,0,0);
	glVertex3f(a,-a,a);
	glVertex3f(a,a,a);
	glVertex3f(a,a,-a);
	glVertex3f(a,-a,-a);
	//lewa
   glNormal3f(-1,0,0);
	glVertex3f(-a,-a,a);
	glVertex3f(-a,a,a);
	glVertex3f(-a,a,-a);
	glVertex3f(-a,-a,-a);

	//gorna
   glNormal3f(0,1,0);
	glVertex3f(-a,a,a);
	glVertex3f(a,a,a);
	glVertex3f(a,a,-a);
	glVertex3f(-a,a,-a);
	//dolna
   glNormal3f(0,-1,0);
	glVertex3f(-a,-a,a);
	glVertex3f(a,-a,a);
	glVertex3f(a,-a,-a);
	glVertex3f(-a,-a,-a);
	//

	glEnd();
}

void __fastcall TForm1::Swiatlo1()
{
   const float kolor1_rozproszone[]={0.5,0.5,0.5,1.0};
   glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor1_rozproszone);
   glEnable(GL_LIGHT1);
}

